package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DefaultButtonConfiguration(
    backgroundColor: Optional[__string] = Optional.Absent,
    borderRadius: Optional[__integer] = Optional.Absent,
    buttonAction: zio.aws.pinpoint.model.ButtonAction,
    link: Optional[__string] = Optional.Absent,
    text: __string,
    textColor: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration = {
    import DefaultButtonConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
      .builder()
      .optionallyWith(backgroundColor.map(value => value: java.lang.String))(
        _.backgroundColor
      )
      .optionallyWith(borderRadius.map(value => value: Integer))(_.borderRadius)
      .buttonAction(buttonAction.unwrap)
      .optionallyWith(link.map(value => value: java.lang.String))(_.link)
      .text(text: java.lang.String)
      .optionallyWith(textColor.map(value => value: java.lang.String))(
        _.textColor
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly =
    zio.aws.pinpoint.model.DefaultButtonConfiguration.wrap(buildAwsValue())
}
object DefaultButtonConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DefaultButtonConfiguration =
      zio.aws.pinpoint.model.DefaultButtonConfiguration(
        backgroundColor.map(value => value),
        borderRadius.map(value => value),
        buttonAction,
        link.map(value => value),
        text,
        textColor.map(value => value)
      )
    def backgroundColor: Optional[__string]
    def borderRadius: Optional[__integer]
    def buttonAction: zio.aws.pinpoint.model.ButtonAction
    def link: Optional[__string]
    def text: __string
    def textColor: Optional[__string]
    def getBackgroundColor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("backgroundColor", backgroundColor)
    def getBorderRadius: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("borderRadius", borderRadius)
    def getButtonAction
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ButtonAction] =
      ZIO.succeed(buttonAction)
    def getLink: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("link", link)
    def getText: ZIO[Any, Nothing, __string] = ZIO.succeed(text)
    def getTextColor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("textColor", textColor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
  ) extends zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly {
    override val backgroundColor: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.backgroundColor())
      .map(value => value: __string)
    override val borderRadius: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.borderRadius())
      .map(value => value: __integer)
    override val buttonAction: zio.aws.pinpoint.model.ButtonAction =
      zio.aws.pinpoint.model.ButtonAction.wrap(impl.buttonAction())
    override val link: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.link())
      .map(value => value: __string)
    override val text: __string = impl.text(): __string
    override val textColor: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.textColor())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration
  ): zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
