package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomMessageActivity(
    deliveryUri: Optional[__string] = Optional.Absent,
    endpointTypes: Optional[
      Iterable[zio.aws.pinpoint.model.EndpointTypesElement]
    ] = Optional.Absent,
    messageConfig: Optional[zio.aws.pinpoint.model.JourneyCustomMessage] =
      Optional.Absent,
    nextActivity: Optional[__string] = Optional.Absent,
    templateName: Optional[__string] = Optional.Absent,
    templateVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity = {
    import CustomMessageActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
      .builder()
      .optionallyWith(deliveryUri.map(value => value: java.lang.String))(
        _.deliveryUri
      )
      .optionallyWith(
        endpointTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.endpointTypesWithStrings)
      .optionallyWith(messageConfig.map(value => value.buildAwsValue()))(
        _.messageConfig
      )
      .optionallyWith(nextActivity.map(value => value: java.lang.String))(
        _.nextActivity
      )
      .optionallyWith(templateName.map(value => value: java.lang.String))(
        _.templateName
      )
      .optionallyWith(templateVersion.map(value => value: java.lang.String))(
        _.templateVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly =
    zio.aws.pinpoint.model.CustomMessageActivity.wrap(buildAwsValue())
}
object CustomMessageActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CustomMessageActivity =
      zio.aws.pinpoint.model.CustomMessageActivity(
        deliveryUri.map(value => value),
        endpointTypes.map(value => value),
        messageConfig.map(value => value.asEditable),
        nextActivity.map(value => value),
        templateName.map(value => value),
        templateVersion.map(value => value)
      )
    def deliveryUri: Optional[__string]
    def endpointTypes
        : Optional[List[zio.aws.pinpoint.model.EndpointTypesElement]]
    def messageConfig
        : Optional[zio.aws.pinpoint.model.JourneyCustomMessage.ReadOnly]
    def nextActivity: Optional[__string]
    def templateName: Optional[__string]
    def templateVersion: Optional[__string]
    def getDeliveryUri: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deliveryUri", deliveryUri)
    def getEndpointTypes: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.EndpointTypesElement
    ]] = AwsError.unwrapOptionField("endpointTypes", endpointTypes)
    def getMessageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.JourneyCustomMessage.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfig", messageConfig)
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getTemplateName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
  ) extends zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly {
    override val deliveryUri: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryUri())
      .map(value => value: __string)
    override val endpointTypes
        : Optional[List[zio.aws.pinpoint.model.EndpointTypesElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.EndpointTypesElement.wrap(item)
          }.toList
        )
    override val messageConfig
        : Optional[zio.aws.pinpoint.model.JourneyCustomMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageConfig())
        .map(value => zio.aws.pinpoint.model.JourneyCustomMessage.wrap(value))
    override val nextActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextActivity())
      .map(value => value: __string)
    override val templateName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => value: __string)
    override val templateVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CustomMessageActivity
  ): zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly = new Wrapper(impl)
}
