package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreatePushTemplateRequest(
    pushNotificationTemplateRequest: zio.aws.pinpoint.model.PushNotificationTemplateRequest,
    templateName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest = {
    import CreatePushTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest
      .builder()
      .pushNotificationTemplateRequest(
        pushNotificationTemplateRequest.buildAwsValue()
      )
      .templateName(templateName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreatePushTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.CreatePushTemplateRequest.wrap(buildAwsValue())
}
object CreatePushTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreatePushTemplateRequest =
      zio.aws.pinpoint.model.CreatePushTemplateRequest(
        pushNotificationTemplateRequest.asEditable,
        templateName
      )
    def pushNotificationTemplateRequest
        : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly
    def templateName: __string
    def getPushNotificationTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly
    ] = ZIO.succeed(pushNotificationTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest
  ) extends zio.aws.pinpoint.model.CreatePushTemplateRequest.ReadOnly {
    override val pushNotificationTemplateRequest
        : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.PushNotificationTemplateRequest
        .wrap(impl.pushNotificationTemplateRequest())
    override val templateName: __string = impl.templateName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest
  ): zio.aws.pinpoint.model.CreatePushTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
