package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConditionalSplitActivity(
    condition: Optional[zio.aws.pinpoint.model.Condition] = Optional.Absent,
    evaluationWaitTime: Optional[zio.aws.pinpoint.model.WaitTime] =
      Optional.Absent,
    falseActivity: Optional[__string] = Optional.Absent,
    trueActivity: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity = {
    import ConditionalSplitActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(evaluationWaitTime.map(value => value.buildAwsValue()))(
        _.evaluationWaitTime
      )
      .optionallyWith(falseActivity.map(value => value: java.lang.String))(
        _.falseActivity
      )
      .optionallyWith(trueActivity.map(value => value: java.lang.String))(
        _.trueActivity
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly =
    zio.aws.pinpoint.model.ConditionalSplitActivity.wrap(buildAwsValue())
}
object ConditionalSplitActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ConditionalSplitActivity =
      zio.aws.pinpoint.model.ConditionalSplitActivity(
        condition.map(value => value.asEditable),
        evaluationWaitTime.map(value => value.asEditable),
        falseActivity.map(value => value),
        trueActivity.map(value => value)
      )
    def condition: Optional[zio.aws.pinpoint.model.Condition.ReadOnly]
    def evaluationWaitTime: Optional[zio.aws.pinpoint.model.WaitTime.ReadOnly]
    def falseActivity: Optional[__string]
    def trueActivity: Optional[__string]
    def getCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Condition.ReadOnly] =
      AwsError.unwrapOptionField("condition", condition)
    def getEvaluationWaitTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.WaitTime.ReadOnly] =
      AwsError.unwrapOptionField("evaluationWaitTime", evaluationWaitTime)
    def getFalseActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("falseActivity", falseActivity)
    def getTrueActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("trueActivity", trueActivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
  ) extends zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly {
    override val condition
        : Optional[zio.aws.pinpoint.model.Condition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.condition())
        .map(value => zio.aws.pinpoint.model.Condition.wrap(value))
    override val evaluationWaitTime
        : Optional[zio.aws.pinpoint.model.WaitTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationWaitTime())
        .map(value => zio.aws.pinpoint.model.WaitTime.wrap(value))
    override val falseActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.falseActivity())
      .map(value => value: __string)
    override val trueActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.trueActivity())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ConditionalSplitActivity
  ): zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly = new Wrapper(
    impl
  )
}
