package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait ChannelType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.ChannelType
}
object ChannelType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.ChannelType
  ): zio.aws.pinpoint.model.ChannelType = value match {
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.PUSH =>
      val r = PUSH
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.GCM =>
      val r = GCM
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS =>
      val r = APNS
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS_SANDBOX =>
      val r = APNS_SANDBOX
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS_VOIP =>
      val r = APNS_VOIP
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS_VOIP_SANDBOX =>
      val r = APNS_VOIP_SANDBOX
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.ADM =>
      val r = ADM
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.VOICE =>
      val r = VOICE
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.BAIDU =>
      val r = BAIDU
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.pinpoint.model.ChannelType.IN_APP =>
      val r = IN_APP
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUSH extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.PUSH
  }
  case object GCM extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.GCM
  }
  case object APNS extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS
  }
  case object APNS_SANDBOX extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS_SANDBOX
  }
  case object APNS_VOIP extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS_VOIP
  }
  case object APNS_VOIP_SANDBOX extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.APNS_VOIP_SANDBOX
  }
  case object ADM extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.ADM
  }
  case object SMS extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.SMS
  }
  case object VOICE extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.VOICE
  }
  case object EMAIL extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.EMAIL
  }
  case object BAIDU extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.BAIDU
  }
  case object CUSTOM extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.CUSTOM
  }
  case object IN_APP extends zio.aws.pinpoint.model.ChannelType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ChannelType =
      software.amazon.awssdk.services.pinpoint.model.ChannelType.IN_APP
  }
}
