package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BaseKpiResult(
    rows: Iterable[zio.aws.pinpoint.model.ResultRow]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.BaseKpiResult = {
    import BaseKpiResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.BaseKpiResult
      .builder()
      .rows(rows.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly =
    zio.aws.pinpoint.model.BaseKpiResult.wrap(buildAwsValue())
}
object BaseKpiResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.BaseKpiResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.BaseKpiResult =
      zio.aws.pinpoint.model.BaseKpiResult(rows.map { item =>
        item.asEditable
      })
    def rows: List[zio.aws.pinpoint.model.ResultRow.ReadOnly]
    def getRows
        : ZIO[Any, Nothing, List[zio.aws.pinpoint.model.ResultRow.ReadOnly]] =
      ZIO.succeed(rows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.BaseKpiResult
  ) extends zio.aws.pinpoint.model.BaseKpiResult.ReadOnly {
    override val rows: List[zio.aws.pinpoint.model.ResultRow.ReadOnly] = impl
      .rows()
      .asScala
      .map { item =>
        zio.aws.pinpoint.model.ResultRow.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.BaseKpiResult
  ): zio.aws.pinpoint.model.BaseKpiResult.ReadOnly = new Wrapper(impl)
}
