package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddressConfiguration(
    bodyOverride: Optional[__string] = Optional.Absent,
    channelType: Optional[zio.aws.pinpoint.model.ChannelType] = Optional.Absent,
    context: Optional[Map[__string, __string]] = Optional.Absent,
    rawContent: Optional[__string] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] =
      Optional.Absent,
    titleOverride: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.AddressConfiguration = {
    import AddressConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
      .builder()
      .optionallyWith(bodyOverride.map(value => value: java.lang.String))(
        _.bodyOverride
      )
      .optionallyWith(channelType.map(value => value.unwrap))(_.channelType)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(rawContent.map(value => value: java.lang.String))(
        _.rawContent
      )
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(titleOverride.map(value => value: java.lang.String))(
        _.titleOverride
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.AddressConfiguration.ReadOnly =
    zio.aws.pinpoint.model.AddressConfiguration.wrap(buildAwsValue())
}
object AddressConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.AddressConfiguration =
      zio.aws.pinpoint.model.AddressConfiguration(
        bodyOverride.map(value => value),
        channelType.map(value => value),
        context.map(value => value),
        rawContent.map(value => value),
        substitutions.map(value => value),
        titleOverride.map(value => value)
      )
    def bodyOverride: Optional[__string]
    def channelType: Optional[zio.aws.pinpoint.model.ChannelType]
    def context: Optional[Map[__string, __string]]
    def rawContent: Optional[__string]
    def substitutions: Optional[Map[__string, List[__string]]]
    def titleOverride: Optional[__string]
    def getBodyOverride: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bodyOverride", bodyOverride)
    def getChannelType: ZIO[Any, AwsError, zio.aws.pinpoint.model.ChannelType] =
      AwsError.unwrapOptionField("channelType", channelType)
    def getContext: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("context", context)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getTitleOverride: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("titleOverride", titleOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
  ) extends zio.aws.pinpoint.model.AddressConfiguration.ReadOnly {
    override val bodyOverride: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bodyOverride())
      .map(value => value: __string)
    override val channelType: Optional[zio.aws.pinpoint.model.ChannelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelType())
        .map(value => zio.aws.pinpoint.model.ChannelType.wrap(value))
    override val context: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.context())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val rawContent: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.rawContent())
      .map(value => value: __string)
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val titleOverride: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.titleOverride())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
  ): zio.aws.pinpoint.model.AddressConfiguration.ReadOnly = new Wrapper(impl)
}
