package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ActivityResponse(
    applicationId: __string,
    campaignId: __string,
    end: Optional[__string] = Optional.Absent,
    id: __string,
    result: Optional[__string] = Optional.Absent,
    scheduledStart: Optional[__string] = Optional.Absent,
    start: Optional[__string] = Optional.Absent,
    state: Optional[__string] = Optional.Absent,
    successfulEndpointCount: Optional[__integer] = Optional.Absent,
    timezonesCompletedCount: Optional[__integer] = Optional.Absent,
    timezonesTotalCount: Optional[__integer] = Optional.Absent,
    totalEndpointCount: Optional[__integer] = Optional.Absent,
    treatmentId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ActivityResponse = {
    import ActivityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ActivityResponse
      .builder()
      .applicationId(applicationId: java.lang.String)
      .campaignId(campaignId: java.lang.String)
      .optionallyWith(end.map(value => value: java.lang.String))(_.end)
      .id(id: java.lang.String)
      .optionallyWith(result.map(value => value: java.lang.String))(_.result)
      .optionallyWith(scheduledStart.map(value => value: java.lang.String))(
        _.scheduledStart
      )
      .optionallyWith(start.map(value => value: java.lang.String))(_.start)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(successfulEndpointCount.map(value => value: Integer))(
        _.successfulEndpointCount
      )
      .optionallyWith(timezonesCompletedCount.map(value => value: Integer))(
        _.timezonesCompletedCount
      )
      .optionallyWith(timezonesTotalCount.map(value => value: Integer))(
        _.timezonesTotalCount
      )
      .optionallyWith(totalEndpointCount.map(value => value: Integer))(
        _.totalEndpointCount
      )
      .optionallyWith(treatmentId.map(value => value: java.lang.String))(
        _.treatmentId
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ActivityResponse.ReadOnly =
    zio.aws.pinpoint.model.ActivityResponse.wrap(buildAwsValue())
}
object ActivityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ActivityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ActivityResponse =
      zio.aws.pinpoint.model.ActivityResponse(
        applicationId,
        campaignId,
        end.map(value => value),
        id,
        result.map(value => value),
        scheduledStart.map(value => value),
        start.map(value => value),
        state.map(value => value),
        successfulEndpointCount.map(value => value),
        timezonesCompletedCount.map(value => value),
        timezonesTotalCount.map(value => value),
        totalEndpointCount.map(value => value),
        treatmentId.map(value => value)
      )
    def applicationId: __string
    def campaignId: __string
    def end: Optional[__string]
    def id: __string
    def result: Optional[__string]
    def scheduledStart: Optional[__string]
    def start: Optional[__string]
    def state: Optional[__string]
    def successfulEndpointCount: Optional[__integer]
    def timezonesCompletedCount: Optional[__integer]
    def timezonesTotalCount: Optional[__integer]
    def totalEndpointCount: Optional[__integer]
    def treatmentId: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignId: ZIO[Any, Nothing, __string] = ZIO.succeed(campaignId)
    def getEnd: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("end", end)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getResult: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("result", result)
    def getScheduledStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("scheduledStart", scheduledStart)
    def getStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("start", start)
    def getState: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("state", state)
    def getSuccessfulEndpointCount: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("successfulEndpointCount", successfulEndpointCount)
    def getTimezonesCompletedCount: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("timezonesCompletedCount", timezonesCompletedCount)
    def getTimezonesTotalCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timezonesTotalCount", timezonesTotalCount)
    def getTotalEndpointCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalEndpointCount", totalEndpointCount)
    def getTreatmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentId", treatmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ActivityResponse
  ) extends zio.aws.pinpoint.model.ActivityResponse.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val campaignId: __string = impl.campaignId(): __string
    override val end: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => value: __string)
    override val id: __string = impl.id(): __string
    override val result: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => value: __string)
    override val scheduledStart: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledStart())
      .map(value => value: __string)
    override val start: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => value: __string)
    override val state: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: __string)
    override val successfulEndpointCount: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successfulEndpointCount())
        .map(value => value: __integer)
    override val timezonesCompletedCount: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timezonesCompletedCount())
        .map(value => value: __integer)
    override val timezonesTotalCount: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timezonesTotalCount())
        .map(value => value: __integer)
    override val totalEndpointCount: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalEndpointCount())
      .map(value => value: __integer)
    override val treatmentId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.treatmentId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ActivityResponse
  ): zio.aws.pinpoint.model.ActivityResponse.ReadOnly = new Wrapper(impl)
}
