package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Action {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Action
}
object Action {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Action
  ): zio.aws.pinpoint.model.Action = value match {
    case software.amazon.awssdk.services.pinpoint.model.Action.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Action.OPEN_APP =>
      val r = OPEN_APP
      r
    case software.amazon.awssdk.services.pinpoint.model.Action.DEEP_LINK =>
      val r = DEEP_LINK
      r
    case software.amazon.awssdk.services.pinpoint.model.Action.URL =>
      val r = URL
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Action {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Action =
      software.amazon.awssdk.services.pinpoint.model.Action.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN_APP extends zio.aws.pinpoint.model.Action {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Action =
      software.amazon.awssdk.services.pinpoint.model.Action.OPEN_APP
  }
  case object DEEP_LINK extends zio.aws.pinpoint.model.Action {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Action =
      software.amazon.awssdk.services.pinpoint.model.Action.DEEP_LINK
  }
  case object URL extends zio.aws.pinpoint.model.Action {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Action =
      software.amazon.awssdk.services.pinpoint.model.Action.URL
  }
}
