package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__boolean, __integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class APNSMessage(
    apnsPushType: Optional[__string] = Optional.Absent,
    action: Optional[zio.aws.pinpoint.model.Action] = Optional.Absent,
    badge: Optional[__integer] = Optional.Absent,
    body: Optional[__string] = Optional.Absent,
    category: Optional[__string] = Optional.Absent,
    collapseId: Optional[__string] = Optional.Absent,
    data: Optional[Map[__string, __string]] = Optional.Absent,
    mediaUrl: Optional[__string] = Optional.Absent,
    preferredAuthenticationMethod: Optional[__string] = Optional.Absent,
    priority: Optional[__string] = Optional.Absent,
    rawContent: Optional[__string] = Optional.Absent,
    silentPush: Optional[__boolean] = Optional.Absent,
    sound: Optional[__string] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] =
      Optional.Absent,
    threadId: Optional[__string] = Optional.Absent,
    timeToLive: Optional[__integer] = Optional.Absent,
    title: Optional[__string] = Optional.Absent,
    url: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.APNSMessage = {
    import APNSMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.APNSMessage
      .builder()
      .optionallyWith(apnsPushType.map(value => value: java.lang.String))(
        _.apnsPushType
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(badge.map(value => value: Integer))(_.badge)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(category.map(value => value: java.lang.String))(
        _.category
      )
      .optionallyWith(collapseId.map(value => value: java.lang.String))(
        _.collapseId
      )
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.data)
      .optionallyWith(mediaUrl.map(value => value: java.lang.String))(
        _.mediaUrl
      )
      .optionallyWith(
        preferredAuthenticationMethod.map(value => value: java.lang.String)
      )(_.preferredAuthenticationMethod)
      .optionallyWith(priority.map(value => value: java.lang.String))(
        _.priority
      )
      .optionallyWith(rawContent.map(value => value: java.lang.String))(
        _.rawContent
      )
      .optionallyWith(silentPush.map(value => value: java.lang.Boolean))(
        _.silentPush
      )
      .optionallyWith(sound.map(value => value: java.lang.String))(_.sound)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(threadId.map(value => value: java.lang.String))(
        _.threadId
      )
      .optionallyWith(timeToLive.map(value => value: Integer))(_.timeToLive)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.APNSMessage.ReadOnly =
    zio.aws.pinpoint.model.APNSMessage.wrap(buildAwsValue())
}
object APNSMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.APNSMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.APNSMessage =
      zio.aws.pinpoint.model.APNSMessage(
        apnsPushType.map(value => value),
        action.map(value => value),
        badge.map(value => value),
        body.map(value => value),
        category.map(value => value),
        collapseId.map(value => value),
        data.map(value => value),
        mediaUrl.map(value => value),
        preferredAuthenticationMethod.map(value => value),
        priority.map(value => value),
        rawContent.map(value => value),
        silentPush.map(value => value),
        sound.map(value => value),
        substitutions.map(value => value),
        threadId.map(value => value),
        timeToLive.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def apnsPushType: Optional[__string]
    def action: Optional[zio.aws.pinpoint.model.Action]
    def badge: Optional[__integer]
    def body: Optional[__string]
    def category: Optional[__string]
    def collapseId: Optional[__string]
    def data: Optional[Map[__string, __string]]
    def mediaUrl: Optional[__string]
    def preferredAuthenticationMethod: Optional[__string]
    def priority: Optional[__string]
    def rawContent: Optional[__string]
    def silentPush: Optional[__boolean]
    def sound: Optional[__string]
    def substitutions: Optional[Map[__string, List[__string]]]
    def threadId: Optional[__string]
    def timeToLive: Optional[__integer]
    def title: Optional[__string]
    def url: Optional[__string]
    def getApnsPushType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apnsPushType", apnsPushType)
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBadge: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("badge", badge)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getCategory: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("category", category)
    def getCollapseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("collapseId", collapseId)
    def getData: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("data", data)
    def getMediaUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mediaUrl", mediaUrl)
    def getPreferredAuthenticationMethod: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "preferredAuthenticationMethod",
        preferredAuthenticationMethod
      )
    def getPriority: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("priority", priority)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getSound: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sound", sound)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getThreadId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("threadId", threadId)
    def getTimeToLive: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSMessage
  ) extends zio.aws.pinpoint.model.APNSMessage.ReadOnly {
    override val apnsPushType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apnsPushType())
      .map(value => value: __string)
    override val action: Optional[zio.aws.pinpoint.model.Action] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val badge: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.badge())
      .map(value => value: __integer)
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val category: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => value: __string)
    override val collapseId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.collapseId())
      .map(value => value: __string)
    override val data: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val mediaUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaUrl())
      .map(value => value: __string)
    override val preferredAuthenticationMethod: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredAuthenticationMethod())
        .map(value => value: __string)
    override val priority: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: __string)
    override val rawContent: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.rawContent())
      .map(value => value: __string)
    override val silentPush: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.silentPush())
      .map(value => value: __boolean)
    override val sound: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sound())
      .map(value => value: __string)
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val threadId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.threadId())
      .map(value => value: __string)
    override val timeToLive: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeToLive())
      .map(value => value: __integer)
    override val title: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: __string)
    override val url: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSMessage
  ): zio.aws.pinpoint.model.APNSMessage.ReadOnly = new Wrapper(impl)
}
