package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class APNSChannelRequest(
    bundleId: Optional[__string] = Optional.Absent,
    certificate: Optional[__string] = Optional.Absent,
    defaultAuthenticationMethod: Optional[__string] = Optional.Absent,
    enabled: Optional[__boolean] = Optional.Absent,
    privateKey: Optional[__string] = Optional.Absent,
    teamId: Optional[__string] = Optional.Absent,
    tokenKey: Optional[__string] = Optional.Absent,
    tokenKeyId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest = {
    import APNSChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
      .builder()
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(certificate.map(value => value: java.lang.String))(
        _.certificate
      )
      .optionallyWith(
        defaultAuthenticationMethod.map(value => value: java.lang.String)
      )(_.defaultAuthenticationMethod)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(privateKey.map(value => value: java.lang.String))(
        _.privateKey
      )
      .optionallyWith(teamId.map(value => value: java.lang.String))(_.teamId)
      .optionallyWith(tokenKey.map(value => value: java.lang.String))(
        _.tokenKey
      )
      .optionallyWith(tokenKeyId.map(value => value: java.lang.String))(
        _.tokenKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.APNSChannelRequest.wrap(buildAwsValue())
}
object APNSChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.APNSChannelRequest =
      zio.aws.pinpoint.model.APNSChannelRequest(
        bundleId.map(value => value),
        certificate.map(value => value),
        defaultAuthenticationMethod.map(value => value),
        enabled.map(value => value),
        privateKey.map(value => value),
        teamId.map(value => value),
        tokenKey.map(value => value),
        tokenKeyId.map(value => value)
      )
    def bundleId: Optional[__string]
    def certificate: Optional[__string]
    def defaultAuthenticationMethod: Optional[__string]
    def enabled: Optional[__boolean]
    def privateKey: Optional[__string]
    def teamId: Optional[__string]
    def tokenKey: Optional[__string]
    def tokenKeyId: Optional[__string]
    def getBundleId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getCertificate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getDefaultAuthenticationMethod: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "defaultAuthenticationMethod",
        defaultAuthenticationMethod
      )
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getPrivateKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getTeamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("teamId", teamId)
    def getTokenKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("tokenKey", tokenKey)
    def getTokenKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("tokenKeyId", tokenKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
  ) extends zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly {
    override val bundleId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => value: __string)
    override val certificate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => value: __string)
    override val defaultAuthenticationMethod: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultAuthenticationMethod())
        .map(value => value: __string)
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val privateKey: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKey())
      .map(value => value: __string)
    override val teamId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.teamId())
      .map(value => value: __string)
    override val tokenKey: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenKey())
      .map(value => value: __string)
    override val tokenKeyId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenKeyId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
  ): zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly = new Wrapper(impl)
}
