package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ADMMessage(
    action: Optional[zio.aws.pinpoint.model.Action] = Optional.Absent,
    body: Optional[__string] = Optional.Absent,
    consolidationKey: Optional[__string] = Optional.Absent,
    data: Optional[Map[__string, __string]] = Optional.Absent,
    expiresAfter: Optional[__string] = Optional.Absent,
    iconReference: Optional[__string] = Optional.Absent,
    imageIconUrl: Optional[__string] = Optional.Absent,
    imageUrl: Optional[__string] = Optional.Absent,
    md5: Optional[__string] = Optional.Absent,
    rawContent: Optional[__string] = Optional.Absent,
    silentPush: Optional[__boolean] = Optional.Absent,
    smallImageIconUrl: Optional[__string] = Optional.Absent,
    sound: Optional[__string] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] =
      Optional.Absent,
    title: Optional[__string] = Optional.Absent,
    url: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ADMMessage = {
    import ADMMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ADMMessage
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(consolidationKey.map(value => value: java.lang.String))(
        _.consolidationKey
      )
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.data)
      .optionallyWith(expiresAfter.map(value => value: java.lang.String))(
        _.expiresAfter
      )
      .optionallyWith(iconReference.map(value => value: java.lang.String))(
        _.iconReference
      )
      .optionallyWith(imageIconUrl.map(value => value: java.lang.String))(
        _.imageIconUrl
      )
      .optionallyWith(imageUrl.map(value => value: java.lang.String))(
        _.imageUrl
      )
      .optionallyWith(md5.map(value => value: java.lang.String))(_.md5)
      .optionallyWith(rawContent.map(value => value: java.lang.String))(
        _.rawContent
      )
      .optionallyWith(silentPush.map(value => value: java.lang.Boolean))(
        _.silentPush
      )
      .optionallyWith(smallImageIconUrl.map(value => value: java.lang.String))(
        _.smallImageIconUrl
      )
      .optionallyWith(sound.map(value => value: java.lang.String))(_.sound)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ADMMessage.ReadOnly =
    zio.aws.pinpoint.model.ADMMessage.wrap(buildAwsValue())
}
object ADMMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ADMMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ADMMessage =
      zio.aws.pinpoint.model.ADMMessage(
        action.map(value => value),
        body.map(value => value),
        consolidationKey.map(value => value),
        data.map(value => value),
        expiresAfter.map(value => value),
        iconReference.map(value => value),
        imageIconUrl.map(value => value),
        imageUrl.map(value => value),
        md5.map(value => value),
        rawContent.map(value => value),
        silentPush.map(value => value),
        smallImageIconUrl.map(value => value),
        sound.map(value => value),
        substitutions.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Optional[zio.aws.pinpoint.model.Action]
    def body: Optional[__string]
    def consolidationKey: Optional[__string]
    def data: Optional[Map[__string, __string]]
    def expiresAfter: Optional[__string]
    def iconReference: Optional[__string]
    def imageIconUrl: Optional[__string]
    def imageUrl: Optional[__string]
    def md5: Optional[__string]
    def rawContent: Optional[__string]
    def silentPush: Optional[__boolean]
    def smallImageIconUrl: Optional[__string]
    def sound: Optional[__string]
    def substitutions: Optional[Map[__string, List[__string]]]
    def title: Optional[__string]
    def url: Optional[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getConsolidationKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("consolidationKey", consolidationKey)
    def getData: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("data", data)
    def getExpiresAfter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("expiresAfter", expiresAfter)
    def getIconReference: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("iconReference", iconReference)
    def getImageIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageIconUrl", imageIconUrl)
    def getImageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getMd5: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("md5", md5)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getSmallImageIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("smallImageIconUrl", smallImageIconUrl)
    def getSound: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sound", sound)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ADMMessage
  ) extends zio.aws.pinpoint.model.ADMMessage.ReadOnly {
    override val action: Optional[zio.aws.pinpoint.model.Action] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val consolidationKey: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.consolidationKey())
      .map(value => value: __string)
    override val data: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val expiresAfter: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresAfter())
      .map(value => value: __string)
    override val iconReference: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.iconReference())
      .map(value => value: __string)
    override val imageIconUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.imageIconUrl())
      .map(value => value: __string)
    override val imageUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUrl())
      .map(value => value: __string)
    override val md5: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.md5())
      .map(value => value: __string)
    override val rawContent: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.rawContent())
      .map(value => value: __string)
    override val silentPush: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.silentPush())
      .map(value => value: __boolean)
    override val smallImageIconUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.smallImageIconUrl())
      .map(value => value: __string)
    override val sound: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sound())
      .map(value => value: __string)
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val title: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: __string)
    override val url: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ADMMessage
  ): zio.aws.pinpoint.model.ADMMessage.ReadOnly = new Wrapper(impl)
}
