package zio.aws.pi.model
import zio.aws.pi.model.primitives.{AnalysisReportId, IdentifierString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPerformanceAnalysisReportRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: IdentifierString,
    analysisReportId: AnalysisReportId,
    textFormat: Optional[zio.aws.pi.model.TextFormat] = Optional.Absent,
    acceptLanguage: Optional[zio.aws.pi.model.AcceptLanguage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportRequest = {
    import GetPerformanceAnalysisReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(IdentifierString.unwrap(identifier): java.lang.String)
      .analysisReportId(
        AnalysisReportId.unwrap(analysisReportId): java.lang.String
      )
      .optionallyWith(textFormat.map(value => value.unwrap))(_.textFormat)
      .optionallyWith(acceptLanguage.map(value => value.unwrap))(
        _.acceptLanguage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.GetPerformanceAnalysisReportRequest.ReadOnly =
    zio.aws.pi.model.GetPerformanceAnalysisReportRequest.wrap(buildAwsValue())
}
object GetPerformanceAnalysisReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetPerformanceAnalysisReportRequest =
      zio.aws.pi.model.GetPerformanceAnalysisReportRequest(
        serviceType,
        identifier,
        analysisReportId,
        textFormat.map(value => value),
        acceptLanguage.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: IdentifierString
    def analysisReportId: AnalysisReportId
    def textFormat: Optional[zio.aws.pi.model.TextFormat]
    def acceptLanguage: Optional[zio.aws.pi.model.AcceptLanguage]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, IdentifierString] =
      ZIO.succeed(identifier)
    def getAnalysisReportId: ZIO[Any, Nothing, AnalysisReportId] =
      ZIO.succeed(analysisReportId)
    def getTextFormat: ZIO[Any, AwsError, zio.aws.pi.model.TextFormat] =
      AwsError.unwrapOptionField("textFormat", textFormat)
    def getAcceptLanguage: ZIO[Any, AwsError, zio.aws.pi.model.AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportRequest
  ) extends zio.aws.pi.model.GetPerformanceAnalysisReportRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: IdentifierString =
      zio.aws.pi.model.primitives.IdentifierString(impl.identifier())
    override val analysisReportId: AnalysisReportId =
      zio.aws.pi.model.primitives.AnalysisReportId(impl.analysisReportId())
    override val textFormat: Optional[zio.aws.pi.model.TextFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textFormat())
        .map(value => zio.aws.pi.model.TextFormat.wrap(value))
    override val acceptLanguage: Optional[zio.aws.pi.model.AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value => zio.aws.pi.model.AcceptLanguage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportRequest
  ): zio.aws.pi.model.GetPerformanceAnalysisReportRequest.ReadOnly =
    new Wrapper(impl)
}
