package zio.aws.pi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{ISOTimestamp, IdentifierString}
import scala.jdk.CollectionConverters._
final case class CreatePerformanceAnalysisReportRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: IdentifierString,
    startTime: ISOTimestamp,
    endTime: ISOTimestamp,
    tags: Optional[Iterable[zio.aws.pi.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportRequest = {
    import CreatePerformanceAnalysisReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(IdentifierString.unwrap(identifier): java.lang.String)
      .startTime(ISOTimestamp.unwrap(startTime): Instant)
      .endTime(ISOTimestamp.unwrap(endTime): Instant)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.CreatePerformanceAnalysisReportRequest.ReadOnly =
    zio.aws.pi.model.CreatePerformanceAnalysisReportRequest
      .wrap(buildAwsValue())
}
object CreatePerformanceAnalysisReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.CreatePerformanceAnalysisReportRequest =
      zio.aws.pi.model.CreatePerformanceAnalysisReportRequest(
        serviceType,
        identifier,
        startTime,
        endTime,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: IdentifierString
    def startTime: ISOTimestamp
    def endTime: ISOTimestamp
    def tags: Optional[List[zio.aws.pi.model.Tag.ReadOnly]]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, IdentifierString] =
      ZIO.succeed(identifier)
    def getStartTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(endTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.pi.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportRequest
  ) extends zio.aws.pi.model.CreatePerformanceAnalysisReportRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: IdentifierString =
      zio.aws.pi.model.primitives.IdentifierString(impl.identifier())
    override val startTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.startTime())
    override val endTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.endTime())
    override val tags: Optional[List[zio.aws.pi.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportRequest
  ): zio.aws.pi.model.CreatePerformanceAnalysisReportRequest.ReadOnly =
    new Wrapper(impl)
}
