package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait Severity {
  def unwrap: software.amazon.awssdk.services.pi.model.Severity
}
object Severity {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.Severity
  ): zio.aws.pi.model.Severity = value match {
    case software.amazon.awssdk.services.pi.model.Severity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.Severity.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.pi.model.Severity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.pi.model.Severity.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.Severity {
    override def unwrap: software.amazon.awssdk.services.pi.model.Severity =
      software.amazon.awssdk.services.pi.model.Severity.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.pi.model.Severity {
    override def unwrap: software.amazon.awssdk.services.pi.model.Severity =
      software.amazon.awssdk.services.pi.model.Severity.LOW
  }
  case object MEDIUM extends zio.aws.pi.model.Severity {
    override def unwrap: software.amazon.awssdk.services.pi.model.Severity =
      software.amazon.awssdk.services.pi.model.Severity.MEDIUM
  }
  case object HIGH extends zio.aws.pi.model.Severity {
    override def unwrap: software.amazon.awssdk.services.pi.model.Severity =
      software.amazon.awssdk.services.pi.model.Severity.HIGH
  }
}
