package zio.aws.pi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{
  NextToken,
  IdentifierString,
  RequestString,
  ISOTimestamp,
  Integer,
  MaxResults
}
import scala.jdk.CollectionConverters._
final case class DescribeDimensionKeysRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: IdentifierString,
    startTime: ISOTimestamp,
    endTime: ISOTimestamp,
    metric: RequestString,
    periodInSeconds: Optional[Integer] = Optional.Absent,
    groupBy: zio.aws.pi.model.DimensionGroup,
    additionalMetrics: Optional[Iterable[RequestString]] = Optional.Absent,
    partitionBy: Optional[zio.aws.pi.model.DimensionGroup] = Optional.Absent,
    filter: Optional[Map[RequestString, RequestString]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest = {
    import DescribeDimensionKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(IdentifierString.unwrap(identifier): java.lang.String)
      .startTime(ISOTimestamp.unwrap(startTime): Instant)
      .endTime(ISOTimestamp.unwrap(endTime): Instant)
      .metric(RequestString.unwrap(metric): java.lang.String)
      .optionallyWith(periodInSeconds.map(value => value: java.lang.Integer))(
        _.periodInSeconds
      )
      .groupBy(groupBy.buildAwsValue())
      .optionallyWith(
        additionalMetrics.map(value =>
          value.map { item =>
            RequestString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMetrics)
      .optionallyWith(partitionBy.map(value => value.buildAwsValue()))(
        _.partitionBy
      )
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString.unwrap(key): java.lang.String) -> (RequestString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filter)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DescribeDimensionKeysRequest.ReadOnly =
    zio.aws.pi.model.DescribeDimensionKeysRequest.wrap(buildAwsValue())
}
object DescribeDimensionKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DescribeDimensionKeysRequest =
      zio.aws.pi.model.DescribeDimensionKeysRequest(
        serviceType,
        identifier,
        startTime,
        endTime,
        metric,
        periodInSeconds.map(value => value),
        groupBy.asEditable,
        additionalMetrics.map(value => value),
        partitionBy.map(value => value.asEditable),
        filter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: IdentifierString
    def startTime: ISOTimestamp
    def endTime: ISOTimestamp
    def metric: RequestString
    def periodInSeconds: Optional[Integer]
    def groupBy: zio.aws.pi.model.DimensionGroup.ReadOnly
    def additionalMetrics: Optional[List[RequestString]]
    def partitionBy: Optional[zio.aws.pi.model.DimensionGroup.ReadOnly]
    def filter: Optional[Map[RequestString, RequestString]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, IdentifierString] =
      ZIO.succeed(identifier)
    def getStartTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(endTime)
    def getMetric: ZIO[Any, Nothing, RequestString] = ZIO.succeed(metric)
    def getPeriodInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("periodInSeconds", periodInSeconds)
    def getGroupBy
        : ZIO[Any, Nothing, zio.aws.pi.model.DimensionGroup.ReadOnly] =
      ZIO.succeed(groupBy)
    def getAdditionalMetrics: ZIO[Any, AwsError, List[RequestString]] =
      AwsError.unwrapOptionField("additionalMetrics", additionalMetrics)
    def getPartitionBy
        : ZIO[Any, AwsError, zio.aws.pi.model.DimensionGroup.ReadOnly] =
      AwsError.unwrapOptionField("partitionBy", partitionBy)
    def getFilter: ZIO[Any, AwsError, Map[RequestString, RequestString]] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
  ) extends zio.aws.pi.model.DescribeDimensionKeysRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: IdentifierString =
      zio.aws.pi.model.primitives.IdentifierString(impl.identifier())
    override val startTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.startTime())
    override val endTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.endTime())
    override val metric: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.metric())
    override val periodInSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.periodInSeconds())
      .map(value => value: Integer)
    override val groupBy: zio.aws.pi.model.DimensionGroup.ReadOnly =
      zio.aws.pi.model.DimensionGroup.wrap(impl.groupBy())
    override val additionalMetrics: Optional[List[RequestString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.primitives.RequestString(item)
          }.toList
        )
    override val partitionBy
        : Optional[zio.aws.pi.model.DimensionGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionBy())
        .map(value => zio.aws.pi.model.DimensionGroup.wrap(value))
    override val filter: Optional[Map[RequestString, RequestString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pi.model.primitives.RequestString(
                key
              ) -> zio.aws.pi.model.primitives.RequestString(value)
            })
            .toMap
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.pi.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
  ): zio.aws.pi.model.DescribeDimensionKeysRequest.ReadOnly = new Wrapper(impl)
}
