package zio.aws.pi.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{MaxResults, NextToken, IdentifierString}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPerformanceAnalysisReportsRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: IdentifierString,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    listTags: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest = {
    import ListPerformanceAnalysisReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(IdentifierString.unwrap(identifier): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(listTags.map(value => value: java.lang.Boolean))(
        _.listTags
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListPerformanceAnalysisReportsRequest.ReadOnly =
    zio.aws.pi.model.ListPerformanceAnalysisReportsRequest.wrap(buildAwsValue())
}
object ListPerformanceAnalysisReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListPerformanceAnalysisReportsRequest =
      zio.aws.pi.model.ListPerformanceAnalysisReportsRequest(
        serviceType,
        identifier,
        nextToken.map(value => value),
        maxResults.map(value => value),
        listTags.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: IdentifierString
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def listTags: Optional[Boolean]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, IdentifierString] =
      ZIO.succeed(identifier)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getListTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("listTags", listTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest
  ) extends zio.aws.pi.model.ListPerformanceAnalysisReportsRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: IdentifierString =
      zio.aws.pi.model.primitives.IdentifierString(impl.identifier())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.pi.model.primitives.MaxResults(value))
    override val listTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.listTags())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest
  ): zio.aws.pi.model.ListPerformanceAnalysisReportsRequest.ReadOnly =
    new Wrapper(impl)
}
