package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait TextFormat {
  def unwrap: software.amazon.awssdk.services.pi.model.TextFormat
}
object TextFormat {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.TextFormat
  ): zio.aws.pi.model.TextFormat = value match {
    case software.amazon.awssdk.services.pi.model.TextFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.TextFormat.PLAIN_TEXT =>
      val r = PLAIN_TEXT
      r
    case software.amazon.awssdk.services.pi.model.TextFormat.MARKDOWN =>
      val r = MARKDOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.TextFormat {
    override def unwrap: software.amazon.awssdk.services.pi.model.TextFormat =
      software.amazon.awssdk.services.pi.model.TextFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object PLAIN_TEXT extends zio.aws.pi.model.TextFormat {
    override def unwrap: software.amazon.awssdk.services.pi.model.TextFormat =
      software.amazon.awssdk.services.pi.model.TextFormat.PLAIN_TEXT
  }
  case object MARKDOWN extends zio.aws.pi.model.TextFormat {
    override def unwrap: software.amazon.awssdk.services.pi.model.TextFormat =
      software.amazon.awssdk.services.pi.model.TextFormat.MARKDOWN
  }
}
