package zio.aws.pi.model
import zio.aws.pi.model.primitives.{AnalysisReportId, IdentifierString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePerformanceAnalysisReportRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: IdentifierString,
    analysisReportId: AnalysisReportId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportRequest = {
    import DeletePerformanceAnalysisReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(IdentifierString.unwrap(identifier): java.lang.String)
      .analysisReportId(
        AnalysisReportId.unwrap(analysisReportId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.DeletePerformanceAnalysisReportRequest.ReadOnly =
    zio.aws.pi.model.DeletePerformanceAnalysisReportRequest
      .wrap(buildAwsValue())
}
object DeletePerformanceAnalysisReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DeletePerformanceAnalysisReportRequest =
      zio.aws.pi.model.DeletePerformanceAnalysisReportRequest(
        serviceType,
        identifier,
        analysisReportId
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: IdentifierString
    def analysisReportId: AnalysisReportId
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, IdentifierString] =
      ZIO.succeed(identifier)
    def getAnalysisReportId: ZIO[Any, Nothing, AnalysisReportId] =
      ZIO.succeed(analysisReportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportRequest
  ) extends zio.aws.pi.model.DeletePerformanceAnalysisReportRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: IdentifierString =
      zio.aws.pi.model.primitives.IdentifierString(impl.identifier())
    override val analysisReportId: AnalysisReportId =
      zio.aws.pi.model.primitives.AnalysisReportId(impl.analysisReportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportRequest
  ): zio.aws.pi.model.DeletePerformanceAnalysisReportRequest.ReadOnly =
    new Wrapper(impl)
}
