package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait ContextType {
  def unwrap: software.amazon.awssdk.services.pi.model.ContextType
}
object ContextType {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.ContextType
  ): zio.aws.pi.model.ContextType = value match {
    case software.amazon.awssdk.services.pi.model.ContextType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.ContextType.CAUSAL =>
      val r = CAUSAL
      r
    case software.amazon.awssdk.services.pi.model.ContextType.CONTEXTUAL =>
      val r = CONTEXTUAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.ContextType {
    override def unwrap: software.amazon.awssdk.services.pi.model.ContextType =
      software.amazon.awssdk.services.pi.model.ContextType.UNKNOWN_TO_SDK_VERSION
  }
  case object CAUSAL extends zio.aws.pi.model.ContextType {
    override def unwrap: software.amazon.awssdk.services.pi.model.ContextType =
      software.amazon.awssdk.services.pi.model.ContextType.CAUSAL
  }
  case object CONTEXTUAL extends zio.aws.pi.model.ContextType {
    override def unwrap: software.amazon.awssdk.services.pi.model.ContextType =
      software.amazon.awssdk.services.pi.model.ContextType.CONTEXTUAL
  }
}
