package zio.aws.pi.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{
  MaxResults,
  NextToken,
  RequestString,
  IdentifierString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAvailableResourceMetricsRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: IdentifierString,
    metricTypes: Iterable[RequestString],
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest = {
    import ListAvailableResourceMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(IdentifierString.unwrap(identifier): java.lang.String)
      .metricTypes(metricTypes.map { item =>
        RequestString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListAvailableResourceMetricsRequest.ReadOnly =
    zio.aws.pi.model.ListAvailableResourceMetricsRequest.wrap(buildAwsValue())
}
object ListAvailableResourceMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListAvailableResourceMetricsRequest =
      zio.aws.pi.model.ListAvailableResourceMetricsRequest(
        serviceType,
        identifier,
        metricTypes,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: IdentifierString
    def metricTypes: List[RequestString]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, IdentifierString] =
      ZIO.succeed(identifier)
    def getMetricTypes: ZIO[Any, Nothing, List[RequestString]] =
      ZIO.succeed(metricTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
  ) extends zio.aws.pi.model.ListAvailableResourceMetricsRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: IdentifierString =
      zio.aws.pi.model.primitives.IdentifierString(impl.identifier())
    override val metricTypes: List[RequestString] = impl
      .metricTypes()
      .asScala
      .map { item =>
        zio.aws.pi.model.primitives.RequestString(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.pi.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
  ): zio.aws.pi.model.ListAvailableResourceMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
