package zio.aws.pi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{MarkdownString, ISOTimestamp}
import scala.jdk.CollectionConverters._
final case class Insight(
    insightId: String,
    insightType: Optional[String] = Optional.Absent,
    context: Optional[zio.aws.pi.model.ContextType] = Optional.Absent,
    startTime: Optional[ISOTimestamp] = Optional.Absent,
    endTime: Optional[ISOTimestamp] = Optional.Absent,
    severity: Optional[zio.aws.pi.model.Severity] = Optional.Absent,
    supportingInsights: Optional[Iterable[zio.aws.pi.model.Insight]] =
      Optional.Absent,
    description: Optional[MarkdownString] = Optional.Absent,
    recommendations: Optional[Iterable[zio.aws.pi.model.Recommendation]] =
      Optional.Absent,
    insightData: Optional[Iterable[zio.aws.pi.model.Data]] = Optional.Absent,
    baselineData: Optional[Iterable[zio.aws.pi.model.Data]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pi.model.Insight = {
    import Insight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.Insight
      .builder()
      .insightId(insightId: java.lang.String)
      .optionallyWith(insightType.map(value => value: java.lang.String))(
        _.insightType
      )
      .optionallyWith(context.map(value => value.unwrap))(_.context)
      .optionallyWith(
        startTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(
        supportingInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportingInsights)
      .optionallyWith(
        description.map(value => MarkdownString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .optionallyWith(
        insightData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.insightData)
      .optionallyWith(
        baselineData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.baselineData)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.Insight.ReadOnly =
    zio.aws.pi.model.Insight.wrap(buildAwsValue())
}
object Insight {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.Insight] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.Insight = zio.aws.pi.model.Insight(
      insightId,
      insightType.map(value => value),
      context.map(value => value),
      startTime.map(value => value),
      endTime.map(value => value),
      severity.map(value => value),
      supportingInsights.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      description.map(value => value),
      recommendations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      insightData.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      baselineData.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def insightId: String
    def insightType: Optional[String]
    def context: Optional[zio.aws.pi.model.ContextType]
    def startTime: Optional[ISOTimestamp]
    def endTime: Optional[ISOTimestamp]
    def severity: Optional[zio.aws.pi.model.Severity]
    def supportingInsights: Optional[List[zio.aws.pi.model.Insight.ReadOnly]]
    def description: Optional[MarkdownString]
    def recommendations
        : Optional[List[zio.aws.pi.model.Recommendation.ReadOnly]]
    def insightData: Optional[List[zio.aws.pi.model.Data.ReadOnly]]
    def baselineData: Optional[List[zio.aws.pi.model.Data.ReadOnly]]
    def getInsightId: ZIO[Any, Nothing, String] = ZIO.succeed(insightId)
    def getInsightType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("insightType", insightType)
    def getContext: ZIO[Any, AwsError, zio.aws.pi.model.ContextType] =
      AwsError.unwrapOptionField("context", context)
    def getStartTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSeverity: ZIO[Any, AwsError, zio.aws.pi.model.Severity] =
      AwsError.unwrapOptionField("severity", severity)
    def getSupportingInsights
        : ZIO[Any, AwsError, List[zio.aws.pi.model.Insight.ReadOnly]] =
      AwsError.unwrapOptionField("supportingInsights", supportingInsights)
    def getDescription: ZIO[Any, AwsError, MarkdownString] =
      AwsError.unwrapOptionField("description", description)
    def getRecommendations
        : ZIO[Any, AwsError, List[zio.aws.pi.model.Recommendation.ReadOnly]] =
      AwsError.unwrapOptionField("recommendations", recommendations)
    def getInsightData
        : ZIO[Any, AwsError, List[zio.aws.pi.model.Data.ReadOnly]] =
      AwsError.unwrapOptionField("insightData", insightData)
    def getBaselineData
        : ZIO[Any, AwsError, List[zio.aws.pi.model.Data.ReadOnly]] =
      AwsError.unwrapOptionField("baselineData", baselineData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.Insight
  ) extends zio.aws.pi.model.Insight.ReadOnly {
    override val insightId: String = impl.insightId(): String
    override val insightType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.insightType())
      .map(value => value: String)
    override val context: Optional[zio.aws.pi.model.ContextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.context())
        .map(value => zio.aws.pi.model.ContextType.wrap(value))
    override val startTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val endTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val severity: Optional[zio.aws.pi.model.Severity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.pi.model.Severity.wrap(value))
    override val supportingInsights
        : Optional[List[zio.aws.pi.model.Insight.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportingInsights())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.Insight.wrap(item)
          }.toList
        )
    override val description: Optional[MarkdownString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.pi.model.primitives.MarkdownString(value))
    override val recommendations
        : Optional[List[zio.aws.pi.model.Recommendation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.Recommendation.wrap(item)
          }.toList
        )
    override val insightData: Optional[List[zio.aws.pi.model.Data.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.Data.wrap(item)
          }.toList
        )
    override val baselineData: Optional[List[zio.aws.pi.model.Data.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.Data.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.Insight
  ): zio.aws.pi.model.Insight.ReadOnly = new Wrapper(impl)
}
