package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait AnalysisStatus {
  def unwrap: software.amazon.awssdk.services.pi.model.AnalysisStatus
}
object AnalysisStatus {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.AnalysisStatus
  ): zio.aws.pi.model.AnalysisStatus = value match {
    case software.amazon.awssdk.services.pi.model.AnalysisStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.AnalysisStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.pi.model.AnalysisStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.pi.model.AnalysisStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.AnalysisStatus =
      software.amazon.awssdk.services.pi.model.AnalysisStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.pi.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.AnalysisStatus =
      software.amazon.awssdk.services.pi.model.AnalysisStatus.RUNNING
  }
  case object SUCCEEDED extends zio.aws.pi.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.AnalysisStatus =
      software.amazon.awssdk.services.pi.model.AnalysisStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.pi.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.AnalysisStatus =
      software.amazon.awssdk.services.pi.model.AnalysisStatus.FAILED
  }
}
