package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait FeatureStatus {
  def unwrap: software.amazon.awssdk.services.pi.model.FeatureStatus
}
object FeatureStatus {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.FeatureStatus
  ): zio.aws.pi.model.FeatureStatus = value match {
    case software.amazon.awssdk.services.pi.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.FeatureStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.pi.model.FeatureStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.pi.model.FeatureStatus.UNSUPPORTED =>
      val r = UNSUPPORTED
      r
    case software.amazon.awssdk.services.pi.model.FeatureStatus.ENABLED_PENDING_REBOOT =>
      val r = ENABLED_PENDING_REBOOT
      r
    case software.amazon.awssdk.services.pi.model.FeatureStatus.DISABLED_PENDING_REBOOT =>
      val r = DISABLED_PENDING_REBOOT
      r
    case software.amazon.awssdk.services.pi.model.FeatureStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.FeatureStatus =
      software.amazon.awssdk.services.pi.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.pi.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.FeatureStatus =
      software.amazon.awssdk.services.pi.model.FeatureStatus.ENABLED
  }
  case object DISABLED extends zio.aws.pi.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.FeatureStatus =
      software.amazon.awssdk.services.pi.model.FeatureStatus.DISABLED
  }
  case object UNSUPPORTED extends zio.aws.pi.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.FeatureStatus =
      software.amazon.awssdk.services.pi.model.FeatureStatus.UNSUPPORTED
  }
  case object ENABLED_PENDING_REBOOT extends zio.aws.pi.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.FeatureStatus =
      software.amazon.awssdk.services.pi.model.FeatureStatus.ENABLED_PENDING_REBOOT
  }
  case object DISABLED_PENDING_REBOOT extends zio.aws.pi.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.FeatureStatus =
      software.amazon.awssdk.services.pi.model.FeatureStatus.DISABLED_PENDING_REBOOT
  }
  case object UNKNOWN extends zio.aws.pi.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.FeatureStatus =
      software.amazon.awssdk.services.pi.model.FeatureStatus.UNKNOWN
  }
}
