package zio.aws.pi.model
import zio.aws.pi.model.primitives.RequestString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DimensionKeyDescription(
    dimensions: Optional[Map[RequestString, RequestString]] = Optional.Absent,
    total: Optional[Double] = Optional.Absent,
    additionalMetrics: Optional[Map[RequestString, Double]] = Optional.Absent,
    partitions: Optional[Iterable[Double]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DimensionKeyDescription = {
    import DimensionKeyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DimensionKeyDescription
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString.unwrap(key): java.lang.String) -> (RequestString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dimensions)
      .optionallyWith(total.map(value => value: java.lang.Double))(_.total)
      .optionallyWith(
        additionalMetrics.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString
                .unwrap(key): java.lang.String) -> (value: java.lang.Double)
            })
            .asJava
        )
      )(_.additionalMetrics)
      .optionallyWith(
        partitions.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.partitions)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DimensionKeyDescription.ReadOnly =
    zio.aws.pi.model.DimensionKeyDescription.wrap(buildAwsValue())
}
object DimensionKeyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DimensionKeyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DimensionKeyDescription =
      zio.aws.pi.model.DimensionKeyDescription(
        dimensions.map(value => value),
        total.map(value => value),
        additionalMetrics.map(value => value),
        partitions.map(value => value)
      )
    def dimensions: Optional[Map[RequestString, RequestString]]
    def total: Optional[Double]
    def additionalMetrics: Optional[Map[RequestString, Double]]
    def partitions: Optional[List[Double]]
    def getDimensions: ZIO[Any, AwsError, Map[RequestString, RequestString]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getTotal: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("total", total)
    def getAdditionalMetrics: ZIO[Any, AwsError, Map[RequestString, Double]] =
      AwsError.unwrapOptionField("additionalMetrics", additionalMetrics)
    def getPartitions: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("partitions", partitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDescription
  ) extends zio.aws.pi.model.DimensionKeyDescription.ReadOnly {
    override val dimensions: Optional[Map[RequestString, RequestString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pi.model.primitives.RequestString(
                key
              ) -> zio.aws.pi.model.primitives.RequestString(value)
            })
            .toMap
        )
    override val total: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: Double)
    override val additionalMetrics: Optional[Map[RequestString, Double]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetrics())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pi.model.primitives.RequestString(key) -> (value: Double)
            })
            .toMap
        )
    override val partitions: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.partitions())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDescription
  ): zio.aws.pi.model.DimensionKeyDescription.ReadOnly = new Wrapper(impl)
}
