package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DimensionGroupDetail(
    group: Optional[String] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.pi.model.DimensionDetail]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DimensionGroupDetail = {
    import DimensionGroupDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DimensionGroupDetail
      .builder()
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DimensionGroupDetail.ReadOnly =
    zio.aws.pi.model.DimensionGroupDetail.wrap(buildAwsValue())
}
object DimensionGroupDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DimensionGroupDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DimensionGroupDetail =
      zio.aws.pi.model.DimensionGroupDetail(
        group.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def group: Optional[String]
    def dimensions: Optional[List[zio.aws.pi.model.DimensionDetail.ReadOnly]]
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getDimensions
        : ZIO[Any, AwsError, List[zio.aws.pi.model.DimensionDetail.ReadOnly]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DimensionGroupDetail
  ) extends zio.aws.pi.model.DimensionGroupDetail.ReadOnly {
    override val group: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => value: String)
    override val dimensions
        : Optional[List[zio.aws.pi.model.DimensionDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.DimensionDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DimensionGroupDetail
  ): zio.aws.pi.model.DimensionGroupDetail.ReadOnly = new Wrapper(impl)
}
