package zio.aws.pi.model
import zio.aws.pi.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAvailableResourceMetricsResponse(
    metrics: Optional[Iterable[zio.aws.pi.model.ResponseResourceMetric]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse = {
    import ListAvailableResourceMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
      .builder()
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly =
    zio.aws.pi.model.ListAvailableResourceMetricsResponse.wrap(buildAwsValue())
}
object ListAvailableResourceMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListAvailableResourceMetricsResponse =
      zio.aws.pi.model.ListAvailableResourceMetricsResponse(
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metrics
        : Optional[List[zio.aws.pi.model.ResponseResourceMetric.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.pi.model.ResponseResourceMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
  ) extends zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly {
    override val metrics
        : Optional[List[zio.aws.pi.model.ResponseResourceMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.ResponseResourceMetric.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
  ): zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
