package zio.aws.pi.model
import zio.aws.pi.model.primitives.RequestString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResponsePartitionKey(
    dimensions: Map[RequestString, RequestString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ResponsePartitionKey = {
    import ResponsePartitionKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ResponsePartitionKey
      .builder()
      .dimensions(
        dimensions
          .map({ case (key, value) =>
            (RequestString.unwrap(key): java.lang.String) -> (RequestString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.pi.model.ResponsePartitionKey.ReadOnly =
    zio.aws.pi.model.ResponsePartitionKey.wrap(buildAwsValue())
}
object ResponsePartitionKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ResponsePartitionKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ResponsePartitionKey =
      zio.aws.pi.model.ResponsePartitionKey(dimensions)
    def dimensions: Map[RequestString, RequestString]
    def getDimensions: ZIO[Any, Nothing, Map[RequestString, RequestString]] =
      ZIO.succeed(dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ResponsePartitionKey
  ) extends zio.aws.pi.model.ResponsePartitionKey.ReadOnly {
    override val dimensions: Map[RequestString, RequestString] = impl
      .dimensions()
      .asScala
      .map({ case (key, value) =>
        zio.aws.pi.model.primitives.RequestString(
          key
        ) -> zio.aws.pi.model.primitives.RequestString(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ResponsePartitionKey
  ): zio.aws.pi.model.ResponsePartitionKey.ReadOnly = new Wrapper(impl)
}
