package zio.aws.pi.model
import zio.aws.pi.model.primitives.RequestString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricQuery(
    metric: RequestString,
    groupBy: Optional[zio.aws.pi.model.DimensionGroup] = Optional.Absent,
    filter: Optional[Map[RequestString, RequestString]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pi.model.MetricQuery = {
    import MetricQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.MetricQuery
      .builder()
      .metric(RequestString.unwrap(metric): java.lang.String)
      .optionallyWith(groupBy.map(value => value.buildAwsValue()))(_.groupBy)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString.unwrap(key): java.lang.String) -> (RequestString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.MetricQuery.ReadOnly =
    zio.aws.pi.model.MetricQuery.wrap(buildAwsValue())
}
object MetricQuery {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.MetricQuery] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.MetricQuery = zio.aws.pi.model.MetricQuery(
      metric,
      groupBy.map(value => value.asEditable),
      filter.map(value => value)
    )
    def metric: RequestString
    def groupBy: Optional[zio.aws.pi.model.DimensionGroup.ReadOnly]
    def filter: Optional[Map[RequestString, RequestString]]
    def getMetric: ZIO[Any, Nothing, RequestString] = ZIO.succeed(metric)
    def getGroupBy
        : ZIO[Any, AwsError, zio.aws.pi.model.DimensionGroup.ReadOnly] =
      AwsError.unwrapOptionField("groupBy", groupBy)
    def getFilter: ZIO[Any, AwsError, Map[RequestString, RequestString]] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.MetricQuery
  ) extends zio.aws.pi.model.MetricQuery.ReadOnly {
    override val metric: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.metric())
    override val groupBy: Optional[zio.aws.pi.model.DimensionGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupBy())
        .map(value => zio.aws.pi.model.DimensionGroup.wrap(value))
    override val filter: Optional[Map[RequestString, RequestString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pi.model.primitives.RequestString(
                key
              ) -> zio.aws.pi.model.primitives.RequestString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.MetricQuery
  ): zio.aws.pi.model.MetricQuery.ReadOnly = new Wrapper(impl)
}
