package zio.aws.pi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{NextToken, ISOTimestamp}
import scala.jdk.CollectionConverters._
final case class GetResourceMetricsResponse(
    alignedStartTime: Optional[ISOTimestamp] = Optional.Absent,
    alignedEndTime: Optional[ISOTimestamp] = Optional.Absent,
    identifier: Optional[String] = Optional.Absent,
    metricList: Optional[Iterable[zio.aws.pi.model.MetricKeyDataPoints]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse = {
    import GetResourceMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
      .builder()
      .optionallyWith(
        alignedStartTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedStartTime)
      .optionallyWith(
        alignedEndTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedEndTime)
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(
        metricList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly =
    zio.aws.pi.model.GetResourceMetricsResponse.wrap(buildAwsValue())
}
object GetResourceMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetResourceMetricsResponse =
      zio.aws.pi.model.GetResourceMetricsResponse(
        alignedStartTime.map(value => value),
        alignedEndTime.map(value => value),
        identifier.map(value => value),
        metricList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def alignedStartTime: Optional[ISOTimestamp]
    def alignedEndTime: Optional[ISOTimestamp]
    def identifier: Optional[String]
    def metricList
        : Optional[List[zio.aws.pi.model.MetricKeyDataPoints.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAlignedStartTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedStartTime", alignedStartTime)
    def getAlignedEndTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedEndTime", alignedEndTime)
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getMetricList: ZIO[Any, AwsError, List[
      zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
    ]] = AwsError.unwrapOptionField("metricList", metricList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
  ) extends zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly {
    override val alignedStartTime: Optional[ISOTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alignedStartTime())
        .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val alignedEndTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.alignedEndTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val identifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => value: String)
    override val metricList
        : Optional[List[zio.aws.pi.model.MetricKeyDataPoints.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.MetricKeyDataPoints.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
  ): zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly = new Wrapper(impl)
}
