package zio.aws.pi.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{NextToken, MaxResults, RequestString}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAvailableResourceDimensionsRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: RequestString,
    metrics: Iterable[RequestString],
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest = {
    import ListAvailableResourceDimensionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(RequestString.unwrap(identifier): java.lang.String)
      .metrics(metrics.map { item =>
        RequestString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListAvailableResourceDimensionsRequest.ReadOnly =
    zio.aws.pi.model.ListAvailableResourceDimensionsRequest
      .wrap(buildAwsValue())
}
object ListAvailableResourceDimensionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListAvailableResourceDimensionsRequest =
      zio.aws.pi.model.ListAvailableResourceDimensionsRequest(
        serviceType,
        identifier,
        metrics,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: RequestString
    def metrics: List[RequestString]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, RequestString] =
      ZIO.succeed(identifier)
    def getMetrics: ZIO[Any, Nothing, List[RequestString]] =
      ZIO.succeed(metrics)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest
  ) extends zio.aws.pi.model.ListAvailableResourceDimensionsRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.identifier())
    override val metrics: List[RequestString] = impl
      .metrics()
      .asScala
      .map { item =>
        zio.aws.pi.model.primitives.RequestString(item)
      }
      .toList
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.pi.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest
  ): zio.aws.pi.model.ListAvailableResourceDimensionsRequest.ReadOnly =
    new Wrapper(impl)
}
