package zio.aws.pi.model
import zio.aws.pi.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAvailableResourceMetricsResponse(
    metrics: Option[Iterable[zio.aws.pi.model.ResponseResourceMetric]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse = {
    import ListAvailableResourceMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
      .builder()
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly =
    zio.aws.pi.model.ListAvailableResourceMetricsResponse.wrap(buildAwsValue())
}
object ListAvailableResourceMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListAvailableResourceMetricsResponse =
      zio.aws.pi.model.ListAvailableResourceMetricsResponse(
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metrics: Option[List[zio.aws.pi.model.ResponseResourceMetric.ReadOnly]]
    def nextToken: Option[NextToken]
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.pi.model.ResponseResourceMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
  ) extends zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly {
    override val metrics
        : Option[List[zio.aws.pi.model.ResponseResourceMetric.ReadOnly]] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.ResponseResourceMetric.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse
  ): zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
