package zio.aws.pi.model
import zio.aws.pi.model.primitives.{NextToken, ISOTimestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetResourceMetricsResponse(
    alignedStartTime: Option[ISOTimestamp] = None,
    alignedEndTime: Option[ISOTimestamp] = None,
    identifier: Option[String] = None,
    metricList: Option[Iterable[zio.aws.pi.model.MetricKeyDataPoints]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse = {
    import GetResourceMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
      .builder()
      .optionallyWith(
        alignedStartTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedStartTime)
      .optionallyWith(
        alignedEndTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedEndTime)
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(
        metricList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly =
    zio.aws.pi.model.GetResourceMetricsResponse.wrap(buildAwsValue())
}
object GetResourceMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetResourceMetricsResponse =
      zio.aws.pi.model.GetResourceMetricsResponse(
        alignedStartTime.map(value => value),
        alignedEndTime.map(value => value),
        identifier.map(value => value),
        metricList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def alignedStartTime: Option[ISOTimestamp]
    def alignedEndTime: Option[ISOTimestamp]
    def identifier: Option[String]
    def metricList: Option[List[zio.aws.pi.model.MetricKeyDataPoints.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAlignedStartTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedStartTime", alignedStartTime)
    def getAlignedEndTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedEndTime", alignedEndTime)
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getMetricList: ZIO[Any, AwsError, List[
      zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
    ]] = AwsError.unwrapOptionField("metricList", metricList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
  ) extends zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly {
    override val alignedStartTime: Option[ISOTimestamp] = scala
      .Option(impl.alignedStartTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val alignedEndTime: Option[ISOTimestamp] = scala
      .Option(impl.alignedEndTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val identifier: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
    override val metricList
        : Option[List[zio.aws.pi.model.MetricKeyDataPoints.ReadOnly]] = scala
      .Option(impl.metricList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.MetricKeyDataPoints.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse
  ): zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly = new Wrapper(impl)
}
