package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResourceMetadataResponse(
    identifier: Option[String] = None,
    features: Option[Map[String, zio.aws.pi.model.FeatureMetadata]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetResourceMetadataResponse = {
    import GetResourceMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetResourceMetadataResponse
      .builder()
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(
        features.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.features)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly =
    zio.aws.pi.model.GetResourceMetadataResponse.wrap(buildAwsValue())
}
object GetResourceMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetResourceMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetResourceMetadataResponse =
      zio.aws.pi.model.GetResourceMetadataResponse(
        identifier.map(value => value),
        features.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def identifier: Option[String]
    def features: Option[Map[String, zio.aws.pi.model.FeatureMetadata.ReadOnly]]
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getFeatures: ZIO[Any, AwsError, Map[
      String,
      zio.aws.pi.model.FeatureMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("features", features)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetadataResponse
  ) extends zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly {
    override val identifier: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
    override val features
        : Option[Map[String, zio.aws.pi.model.FeatureMetadata.ReadOnly]] = scala
      .Option(impl.features())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.pi.model.FeatureMetadata.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetadataResponse
  ): zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly = new Wrapper(impl)
}
