package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DimensionDetail(identifier: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DimensionDetail = {
    import DimensionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DimensionDetail
      .builder()
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DimensionDetail.ReadOnly =
    zio.aws.pi.model.DimensionDetail.wrap(buildAwsValue())
}
object DimensionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DimensionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DimensionDetail =
      zio.aws.pi.model.DimensionDetail(identifier.map(value => value))
    def identifier: Option[String]
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DimensionDetail
  ) extends zio.aws.pi.model.DimensionDetail.ReadOnly {
    override val identifier: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DimensionDetail
  ): zio.aws.pi.model.DimensionDetail.ReadOnly = new Wrapper(impl)
}
