package zio.aws.pi
import zio.aws.pi.model.primitives.RequestString
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.pi.model.primitives.IdentifierString.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ISOTimestamp extends Subtype[Instant]
    type ISOTimestamp = zio.aws.pi.model.primitives.ISOTimestamp.Type
    object IdentifierString extends Subtype[String]
    type IdentifierString = zio.aws.pi.model.primitives.IdentifierString.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.pi.model.primitives.Integer.Type
    object Limit extends Subtype[Int]
    type Limit = zio.aws.pi.model.primitives.Limit.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.pi.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.pi.model.primitives.NextToken.Type
    object RequestString extends Subtype[String]
    type RequestString = zio.aws.pi.model.primitives.RequestString.Type
  }
  type DataPointsList = List[zio.aws.pi.model.DataPoint]
  type DimensionKeyDescriptionList =
    List[zio.aws.pi.model.DimensionKeyDescription]
  type DimensionKeyDetailList = List[zio.aws.pi.model.DimensionKeyDetail]
  type DimensionMap = Map[RequestString, RequestString]
  type MetricKeyDataPointsList = List[zio.aws.pi.model.MetricKeyDataPoints]
  type MetricQueryFilterMap = Map[RequestString, RequestString]
  type MetricQueryList = List[zio.aws.pi.model.MetricQuery]
  type MetricValuesList = List[Double]
  type RequestStringList = List[RequestString]
  type RequestedDimensionList = List[RequestString]
  type ResponsePartitionKeyList = List[zio.aws.pi.model.ResponsePartitionKey]
}
