package zio.aws.pi.model
import zio.aws.pi.model.primitives.{TagKey, AmazonResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    resourceARN: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.UntagResourceRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.UntagResourceRequest.ReadOnly =
    zio.aws.pi.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.UntagResourceRequest =
      zio.aws.pi.model.UntagResourceRequest(serviceType, resourceARN, tagKeys)
    def serviceType: zio.aws.pi.model.ServiceType
    def resourceARN: AmazonResourceName
    def tagKeys: List[TagKey]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.UntagResourceRequest
  ) extends zio.aws.pi.model.UntagResourceRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val resourceARN: AmazonResourceName =
      zio.aws.pi.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.pi.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.UntagResourceRequest
  ): zio.aws.pi.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
