package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait ServiceType {
  def unwrap: software.amazon.awssdk.services.pi.model.ServiceType
}
object ServiceType {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.ServiceType
  ): zio.aws.pi.model.ServiceType = value match {
    case software.amazon.awssdk.services.pi.model.ServiceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.ServiceType.RDS =>
      val r = RDS
      r
    case software.amazon.awssdk.services.pi.model.ServiceType.DOCDB =>
      val r = DOCDB
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.pi.model.ServiceType =
      software.amazon.awssdk.services.pi.model.ServiceType.UNKNOWN_TO_SDK_VERSION
  }
  case object RDS extends zio.aws.pi.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.pi.model.ServiceType =
      software.amazon.awssdk.services.pi.model.ServiceType.RDS
  }
  case object DOCDB extends zio.aws.pi.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.pi.model.ServiceType =
      software.amazon.awssdk.services.pi.model.ServiceType.DOCDB
  }
}
