package zio.aws.pi.model
import zio.aws.pi.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    resourceARN: AmazonResourceName,
    tags: Iterable[zio.aws.pi.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.TagResourceRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.TagResourceRequest.ReadOnly =
    zio.aws.pi.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.TagResourceRequest =
      zio.aws.pi.model.TagResourceRequest(
        serviceType,
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def resourceARN: AmazonResourceName
    def tags: List[zio.aws.pi.model.Tag.ReadOnly]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.pi.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.TagResourceRequest
  ) extends zio.aws.pi.model.TagResourceRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val resourceARN: AmazonResourceName =
      zio.aws.pi.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tags: List[zio.aws.pi.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.pi.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.TagResourceRequest
  ): zio.aws.pi.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
