package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPerformanceAnalysisReportResponse(
    analysisReport: Optional[zio.aws.pi.model.AnalysisReport] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportResponse = {
    import GetPerformanceAnalysisReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportResponse
      .builder()
      .optionallyWith(analysisReport.map(value => value.buildAwsValue()))(
        _.analysisReport
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.GetPerformanceAnalysisReportResponse.ReadOnly =
    zio.aws.pi.model.GetPerformanceAnalysisReportResponse.wrap(buildAwsValue())
}
object GetPerformanceAnalysisReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetPerformanceAnalysisReportResponse =
      zio.aws.pi.model.GetPerformanceAnalysisReportResponse(
        analysisReport.map(value => value.asEditable)
      )
    def analysisReport: Optional[zio.aws.pi.model.AnalysisReport.ReadOnly]
    def getAnalysisReport
        : ZIO[Any, AwsError, zio.aws.pi.model.AnalysisReport.ReadOnly] =
      AwsError.unwrapOptionField("analysisReport", analysisReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportResponse
  ) extends zio.aws.pi.model.GetPerformanceAnalysisReportResponse.ReadOnly {
    override val analysisReport
        : Optional[zio.aws.pi.model.AnalysisReport.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisReport())
        .map(value => zio.aws.pi.model.AnalysisReport.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportResponse
  ): zio.aws.pi.model.GetPerformanceAnalysisReportResponse.ReadOnly =
    new Wrapper(impl)
}
