package zio.aws.pi.model
import zio.aws.pi.model.primitives.AnalysisReportId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePerformanceAnalysisReportResponse(
    analysisReportId: Optional[AnalysisReportId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportResponse = {
    import CreatePerformanceAnalysisReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportResponse
      .builder()
      .optionallyWith(
        analysisReportId.map(value =>
          AnalysisReportId.unwrap(value): java.lang.String
        )
      )(_.analysisReportId)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.CreatePerformanceAnalysisReportResponse.ReadOnly =
    zio.aws.pi.model.CreatePerformanceAnalysisReportResponse
      .wrap(buildAwsValue())
}
object CreatePerformanceAnalysisReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.CreatePerformanceAnalysisReportResponse =
      zio.aws.pi.model.CreatePerformanceAnalysisReportResponse(
        analysisReportId.map(value => value)
      )
    def analysisReportId: Optional[AnalysisReportId]
    def getAnalysisReportId: ZIO[Any, AwsError, AnalysisReportId] =
      AwsError.unwrapOptionField("analysisReportId", analysisReportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportResponse
  ) extends zio.aws.pi.model.CreatePerformanceAnalysisReportResponse.ReadOnly {
    override val analysisReportId: Optional[AnalysisReportId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisReportId())
        .map(value => zio.aws.pi.model.primitives.AnalysisReportId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportResponse
  ): zio.aws.pi.model.CreatePerformanceAnalysisReportResponse.ReadOnly =
    new Wrapper(impl)
}
