package zio.aws.pi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.ISOTimestamp
import scala.jdk.CollectionConverters._
final case class AnalysisReportSummary(
    analysisReportId: Optional[String] = Optional.Absent,
    createTime: Optional[ISOTimestamp] = Optional.Absent,
    startTime: Optional[ISOTimestamp] = Optional.Absent,
    endTime: Optional[ISOTimestamp] = Optional.Absent,
    status: Optional[zio.aws.pi.model.AnalysisStatus] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pi.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.AnalysisReportSummary = {
    import AnalysisReportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.AnalysisReportSummary
      .builder()
      .optionallyWith(analysisReportId.map(value => value: java.lang.String))(
        _.analysisReportId
      )
      .optionallyWith(
        createTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        startTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.AnalysisReportSummary.ReadOnly =
    zio.aws.pi.model.AnalysisReportSummary.wrap(buildAwsValue())
}
object AnalysisReportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.AnalysisReportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.AnalysisReportSummary =
      zio.aws.pi.model.AnalysisReportSummary(
        analysisReportId.map(value => value),
        createTime.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def analysisReportId: Optional[String]
    def createTime: Optional[ISOTimestamp]
    def startTime: Optional[ISOTimestamp]
    def endTime: Optional[ISOTimestamp]
    def status: Optional[zio.aws.pi.model.AnalysisStatus]
    def tags: Optional[List[zio.aws.pi.model.Tag.ReadOnly]]
    def getAnalysisReportId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("analysisReportId", analysisReportId)
    def getCreateTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getStartTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.pi.model.AnalysisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.pi.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.AnalysisReportSummary
  ) extends zio.aws.pi.model.AnalysisReportSummary.ReadOnly {
    override val analysisReportId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.analysisReportId())
      .map(value => value: String)
    override val createTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val startTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val endTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val status: Optional[zio.aws.pi.model.AnalysisStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.pi.model.AnalysisStatus.wrap(value))
    override val tags: Optional[List[zio.aws.pi.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.AnalysisReportSummary
  ): zio.aws.pi.model.AnalysisReportSummary.ReadOnly = new Wrapper(impl)
}
