package zio.aws.pi
import zio.aws.pi.model.primitives.{TagKey, DescriptiveString, RequestString}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.pi.model.primitives.TagValue.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.pi.model.primitives.AmazonResourceName.Type
    object AnalysisReportId extends Subtype[String]
    type AnalysisReportId = zio.aws.pi.model.primitives.AnalysisReportId.Type
    object Description extends Subtype[String]
    type Description = zio.aws.pi.model.primitives.Description.Type
    object DescriptiveString extends Subtype[String]
    type DescriptiveString = zio.aws.pi.model.primitives.DescriptiveString.Type
    object ISOTimestamp extends Subtype[Instant]
    type ISOTimestamp = zio.aws.pi.model.primitives.ISOTimestamp.Type
    object IdentifierString extends Subtype[String]
    type IdentifierString = zio.aws.pi.model.primitives.IdentifierString.Type
    type Integer = Int
    object Limit extends Subtype[Int]
    type Limit = zio.aws.pi.model.primitives.Limit.Type
    object MarkdownString extends Subtype[String]
    type MarkdownString = zio.aws.pi.model.primitives.MarkdownString.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.pi.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.pi.model.primitives.NextToken.Type
    object RequestString extends Subtype[String]
    type RequestString = zio.aws.pi.model.primitives.RequestString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.pi.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.pi.model.primitives.TagValue.Type
  }
  type AdditionalMetricsList = List[RequestString]
  type AdditionalMetricsMap = Map[RequestString, Double]
  type AnalysisReportSummaryList = List[zio.aws.pi.model.AnalysisReportSummary]
  type DataList = List[zio.aws.pi.model.Data]
  type DataPointsList = List[zio.aws.pi.model.DataPoint]
  type DescriptiveMap = Map[DescriptiveString, DescriptiveString]
  type DimensionDetailList = List[zio.aws.pi.model.DimensionDetail]
  type DimensionGroupDetailList = List[zio.aws.pi.model.DimensionGroupDetail]
  type DimensionKeyDescriptionList =
    List[zio.aws.pi.model.DimensionKeyDescription]
  type DimensionKeyDetailList = List[zio.aws.pi.model.DimensionKeyDetail]
  type DimensionMap = Map[RequestString, RequestString]
  type DimensionsMetricList = List[RequestString]
  type FeatureMetadataMap = Map[String, zio.aws.pi.model.FeatureMetadata]
  type InsightList = List[zio.aws.pi.model.Insight]
  type MetricDimensionsList = List[zio.aws.pi.model.MetricDimensionGroups]
  type MetricKeyDataPointsList = List[zio.aws.pi.model.MetricKeyDataPoints]
  type MetricQueryFilterMap = Map[RequestString, RequestString]
  type MetricQueryList = List[zio.aws.pi.model.MetricQuery]
  type MetricTypeList = List[RequestString]
  type MetricValuesList = List[Double]
  type RecommendationList = List[zio.aws.pi.model.Recommendation]
  type RequestStringList = List[RequestString]
  type RequestedDimensionList = List[RequestString]
  type ResponsePartitionKeyList = List[zio.aws.pi.model.ResponsePartitionKey]
  type ResponseResourceMetricList =
    List[zio.aws.pi.model.ResponseResourceMetric]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.pi.model.Tag]
}
