package zio.aws.pi.model
import zio.aws.pi.model.primitives.DescriptiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PerformanceInsightsMetric(
    metric: Optional[DescriptiveString] = Optional.Absent,
    displayName: Optional[DescriptiveString] = Optional.Absent,
    dimensions: Optional[Map[DescriptiveString, DescriptiveString]] =
      Optional.Absent,
    value: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.PerformanceInsightsMetric = {
    import PerformanceInsightsMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.PerformanceInsightsMetric
      .builder()
      .optionallyWith(
        metric.map(value => DescriptiveString.unwrap(value): java.lang.String)
      )(_.metric)
      .optionallyWith(
        displayName.map(value =>
          DescriptiveString.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        dimensions.map(value =>
          value
            .map({ case (key, value) =>
              (DescriptiveString
                .unwrap(key): java.lang.String) -> (DescriptiveString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dimensions)
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.PerformanceInsightsMetric.ReadOnly =
    zio.aws.pi.model.PerformanceInsightsMetric.wrap(buildAwsValue())
}
object PerformanceInsightsMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.PerformanceInsightsMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.PerformanceInsightsMetric =
      zio.aws.pi.model.PerformanceInsightsMetric(
        metric.map(value => value),
        displayName.map(value => value),
        dimensions.map(value => value),
        value.map(value => value)
      )
    def metric: Optional[DescriptiveString]
    def displayName: Optional[DescriptiveString]
    def dimensions: Optional[Map[DescriptiveString, DescriptiveString]]
    def value: Optional[Double]
    def getMetric: ZIO[Any, AwsError, DescriptiveString] =
      AwsError.unwrapOptionField("metric", metric)
    def getDisplayName: ZIO[Any, AwsError, DescriptiveString] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDimensions
        : ZIO[Any, AwsError, Map[DescriptiveString, DescriptiveString]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.PerformanceInsightsMetric
  ) extends zio.aws.pi.model.PerformanceInsightsMetric.ReadOnly {
    override val metric: Optional[DescriptiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.metric())
      .map(value => zio.aws.pi.model.primitives.DescriptiveString(value))
    override val displayName: Optional[DescriptiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value => zio.aws.pi.model.primitives.DescriptiveString(value))
    override val dimensions
        : Optional[Map[DescriptiveString, DescriptiveString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pi.model.primitives.DescriptiveString(
                key
              ) -> zio.aws.pi.model.primitives.DescriptiveString(value)
            })
            .toMap
        )
    override val value: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.PerformanceInsightsMetric
  ): zio.aws.pi.model.PerformanceInsightsMetric.ReadOnly = new Wrapper(impl)
}
