package zio.aws.pi.model
import zio.aws.pi.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    resourceARN: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListTagsForResourceRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.pi.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListTagsForResourceRequest =
      zio.aws.pi.model.ListTagsForResourceRequest(serviceType, resourceARN)
    def serviceType: zio.aws.pi.model.ServiceType
    def resourceARN: AmazonResourceName
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListTagsForResourceRequest
  ) extends zio.aws.pi.model.ListTagsForResourceRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val resourceARN: AmazonResourceName =
      zio.aws.pi.model.primitives.AmazonResourceName(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListTagsForResourceRequest
  ): zio.aws.pi.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
