package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait AcceptLanguage {
  def unwrap: software.amazon.awssdk.services.pi.model.AcceptLanguage
}
object AcceptLanguage {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.AcceptLanguage
  ): zio.aws.pi.model.AcceptLanguage = value match {
    case software.amazon.awssdk.services.pi.model.AcceptLanguage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.AcceptLanguage.EN_US =>
      val r = EN_US
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.AcceptLanguage {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.AcceptLanguage =
      software.amazon.awssdk.services.pi.model.AcceptLanguage.UNKNOWN_TO_SDK_VERSION
  }
  case object EN_US extends zio.aws.pi.model.AcceptLanguage {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.AcceptLanguage =
      software.amazon.awssdk.services.pi.model.AcceptLanguage.EN_US
  }
}
