package zio.aws.pi.model
import scala.jdk.CollectionConverters._
sealed trait PeriodAlignment {
  def unwrap: software.amazon.awssdk.services.pi.model.PeriodAlignment
}
object PeriodAlignment {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.PeriodAlignment
  ): zio.aws.pi.model.PeriodAlignment = value match {
    case software.amazon.awssdk.services.pi.model.PeriodAlignment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.PeriodAlignment.END_TIME =>
      val r = END_TIME
      r
    case software.amazon.awssdk.services.pi.model.PeriodAlignment.START_TIME =>
      val r = START_TIME
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.PeriodAlignment {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.PeriodAlignment =
      software.amazon.awssdk.services.pi.model.PeriodAlignment.UNKNOWN_TO_SDK_VERSION
  }
  case object END_TIME extends zio.aws.pi.model.PeriodAlignment {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.PeriodAlignment =
      software.amazon.awssdk.services.pi.model.PeriodAlignment.END_TIME
  }
  case object START_TIME extends zio.aws.pi.model.PeriodAlignment {
    override def unwrap
        : software.amazon.awssdk.services.pi.model.PeriodAlignment =
      software.amazon.awssdk.services.pi.model.PeriodAlignment.START_TIME
  }
}
