package zio.aws.pi.model
import zio.aws.pi.model.primitives.MarkdownString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Recommendation(
    recommendationId: Optional[String] = Optional.Absent,
    recommendationDescription: Optional[MarkdownString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.Recommendation
      .builder()
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .optionallyWith(
        recommendationDescription.map(value =>
          MarkdownString.unwrap(value): java.lang.String
        )
      )(_.recommendationDescription)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.Recommendation.ReadOnly =
    zio.aws.pi.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.Recommendation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.Recommendation =
      zio.aws.pi.model.Recommendation(
        recommendationId.map(value => value),
        recommendationDescription.map(value => value)
      )
    def recommendationId: Optional[String]
    def recommendationDescription: Optional[MarkdownString]
    def getRecommendationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
    def getRecommendationDescription: ZIO[Any, AwsError, MarkdownString] =
      AwsError.unwrapOptionField(
        "recommendationDescription",
        recommendationDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.Recommendation
  ) extends zio.aws.pi.model.Recommendation.ReadOnly {
    override val recommendationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationId())
      .map(value => value: String)
    override val recommendationDescription: Optional[MarkdownString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationDescription())
        .map(value => zio.aws.pi.model.primitives.MarkdownString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.Recommendation
  ): zio.aws.pi.model.Recommendation.ReadOnly = new Wrapper(impl)
}
