package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Data(
    performanceInsightsMetric: Optional[
      zio.aws.pi.model.PerformanceInsightsMetric
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pi.model.Data = {
    import Data.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.Data
      .builder()
      .optionallyWith(
        performanceInsightsMetric.map(value => value.buildAwsValue())
      )(_.performanceInsightsMetric)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.Data.ReadOnly =
    zio.aws.pi.model.Data.wrap(buildAwsValue())
}
object Data {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.Data] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.Data = zio.aws.pi.model
      .Data(performanceInsightsMetric.map(value => value.asEditable))
    def performanceInsightsMetric
        : Optional[zio.aws.pi.model.PerformanceInsightsMetric.ReadOnly]
    def getPerformanceInsightsMetric: ZIO[
      Any,
      AwsError,
      zio.aws.pi.model.PerformanceInsightsMetric.ReadOnly
    ] = AwsError.unwrapOptionField(
      "performanceInsightsMetric",
      performanceInsightsMetric
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.Data
  ) extends zio.aws.pi.model.Data.ReadOnly {
    override val performanceInsightsMetric
        : Optional[zio.aws.pi.model.PerformanceInsightsMetric.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsMetric())
        .map(value => zio.aws.pi.model.PerformanceInsightsMetric.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.Data
  ): zio.aws.pi.model.Data.ReadOnly = new Wrapper(impl)
}
