package zio.aws.pi.model
import zio.aws.pi.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPerformanceAnalysisReportsResponse(
    analysisReports: Optional[
      Iterable[zio.aws.pi.model.AnalysisReportSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse = {
    import ListPerformanceAnalysisReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse
      .builder()
      .optionallyWith(
        analysisReports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.analysisReports)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListPerformanceAnalysisReportsResponse.ReadOnly =
    zio.aws.pi.model.ListPerformanceAnalysisReportsResponse
      .wrap(buildAwsValue())
}
object ListPerformanceAnalysisReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListPerformanceAnalysisReportsResponse =
      zio.aws.pi.model.ListPerformanceAnalysisReportsResponse(
        analysisReports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def analysisReports
        : Optional[List[zio.aws.pi.model.AnalysisReportSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAnalysisReports: ZIO[Any, AwsError, List[
      zio.aws.pi.model.AnalysisReportSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("analysisReports", analysisReports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse
  ) extends zio.aws.pi.model.ListPerformanceAnalysisReportsResponse.ReadOnly {
    override val analysisReports
        : Optional[List[zio.aws.pi.model.AnalysisReportSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisReports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.AnalysisReportSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse
  ): zio.aws.pi.model.ListPerformanceAnalysisReportsResponse.ReadOnly =
    new Wrapper(impl)
}
